//[BotStacks Chat SDK](../../../index.md)/[ai.botstacks.sdk.state](../index.md)/[Pager](index.md)

# Pager

@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)

abstract class [Pager](index.md)&lt;[T](index.md) : [Identifiable](../-identifiable/index.md)&gt;(val id: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = uuid(), val items: [SnapshotStateList](https://developer.android.com/reference/kotlin/androidx/compose/runtime/snapshots/SnapshotStateList.html)&lt;[T](index.md)&gt; = mutableStateListOf(), val pageSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 20)

#### Inheritors

| |
|---|
| [Chat](../-chat/index.md) |
| [ChannelsPager](../-channels-pager/index.md) |
| [UsersPager](../-users-pager/index.md) |
| [ContactsPager](../-contacts-pager/index.md) |
| [FavoritesPager](../-favorites-pager/index.md) |
| [RepliesPager](../-replies-pager/index.md) |

## Constructors

| | |
|---|---|
| [Pager](-pager.md) | [common]<br>constructor(id: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = uuid(), items: [SnapshotStateList](https://developer.android.com/reference/kotlin/androidx/compose/runtime/snapshots/SnapshotStateList.html)&lt;[T](index.md)&gt; = mutableStateListOf(), pageSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 20) |

## Properties

| Name | Summary |
|---|---|
| [hasMore](has-more.md) | [common]<br>var [hasMore](has-more.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [id](id.md) | [common]<br>val [id](id.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [isSinglePage](is-single-page.md) | [common]<br>open val [isSinglePage](is-single-page.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [items](items.md) | [common]<br>val [items](items.md): [SnapshotStateList](https://developer.android.com/reference/kotlin/androidx/compose/runtime/snapshots/SnapshotStateList.html)&lt;[T](index.md)&gt; |
| [loading](loading.md) | [common]<br>var [loading](loading.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [pageSize](page-size.md) | [common]<br>val [pageSize](page-size.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 20 |
| [refreshing](refreshing.md) | [common]<br>var [refreshing](refreshing.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |

## Functions

| Name | Summary |
|---|---|
| [load](load.md) | [common]<br>abstract suspend fun [load](load.md)(skip: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), limit: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[T](index.md)&gt; |
| [loadMore](load-more.md) | [common]<br>fun [loadMore](load-more.md)() |
| [loadMoreIfEmpty](load-more-if-empty.md) | [common]<br>fun [loadMoreIfEmpty](load-more-if-empty.md)() |
| [loadMoreIfNeeded](load-more-if-needed.md) | [common]<br>fun [loadMoreIfNeeded](load-more-if-needed.md)(item: [T](index.md)) |
| [refresh](refresh.md) | [common]<br>fun [refresh](refresh.md)() |
| [skip](skip.md) | [common]<br>fun [skip](skip.md)(isRefresh: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
